<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Achat extends Model 
{

    protected $table = 'achats';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function eleves()
    {
        return $this->belongsToMany('App\Models\Eleve');
    }

    public function forfaits()
    {
        return $this->belongsTo('App\Models\Forfaits', 'forfait');
    }

    public function lecons()
    {
        return $this->hasMany('App\Models\Lecon');
    }

    public function paiement()
    {
        return $this->hasMany('App\Models\Paiements');
    }

    public function horaires()
    {
        return $this->belongsToMany('App\Models\Horaires');
    }

}